#ifdef GL_ES
attribute vec3 inVertex;
attribute vec3 inNormal;

varying vec3 normal, light, halfVector;
varying vec4 darkColor;
varying vec4 lightColor;
varying float dist;
varying float location;
#else
in vec3 inVertex;
in vec3 inNormal;

out vec3 normal, light, halfVector;
out vec4 darkColor;
out vec4 lightColor;
out float dist;
out float location;
#endif
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform vec3 lightSource3;
uniform vec3 lightSource3HV;

void main()
{
	/* first transform the normal into eye space and normalize the result */
	normal = inNormal;
	light = lightSource3;
	vec2 div = 1.0 - (vec2(0.026667, 0.017114) - inVertex.yz) / vec2(0.026667 * 2.0, 0.017114 * 2.0);
	location = 1.0 - inVertex.z / 0.0175;
	dist = min(div.x, div.y);
	dist = pow(dist, 12.0) + dist;

	halfVector = lightSource3HV;

	gl_Position = projectionMatrix * modelViewMatrix * vec4(inVertex, 1.0);
}
